jQuery(function () {

    "use strict";

    /* Preloader */
    jQuery(window).on('load', function () {
        jQuery('.load-icon').delay(50).fadeOut();
        jQuery('.preloader').delay(350).fadeOut('slow');
        jQuery('body').delay(350).css({
            'overflow': 'visible'
        });
    });

    /* Navigation menu */
    jQuery('.burger').on('click', function () {
        jQuery('.nav-menu').toggleClass('active-nav-menu');
        jQuery(this).toggleClass('open');
    });

    jQuery('.auto .nav-menu ul li a').on('click', function () {
        jQuery('.nav-menu').toggleClass('active-nav-menu');
        jQuery('.burger').toggleClass('open');
    });

    /* Success popup */
    jQuery('.popup').on('click', function () {
        jQuery(this).removeClass('active-popup');
        jQuery(this).addClass('n-active-popup');
    });

    //Calculating Logo Size
	var logo_img = document.getElementById('logo_img'); 
	var logo_width = logo_img.clientWidth;
	var logowidth = logo_width+'px';
	var the_body = jQuery(window).width();
	var the_body_width = the_body - logo_width;
	var navwidth_big = the_body_width+'px';
	var nav_container = document.getElementsByClassName('navigation_ul'); 	
	var nav_container_width = nav_container[0].clientWidth;	
	var nav_menu = nav_container_width;
	var navwidth = nav_menu+'px';
	
	//now adding the required style in the custom-css style
	
	
	//if (main_menu_width > 800) {
	if (typeof nav_container_width === "undefined" || nav_container_width > 800) {
		document.querySelector('#custom-style').textContent += "@media screen and (min-width:992px) { .nav-menu.active-nav-menu{ width:"+navwidth_big+";} .active-nav-menu{ left:"+logowidth+" }}";
		//document.querySelector('#custom-style').textContent += "@media screen and (min-width:992px) { .nav-menu{ width:782px } .nav-menu.active-nav-menu{ width:"+navwidth+" } .active-nav-menu{ left:"+logowidth+" }}";
	} else {
		document.querySelector('#custom-style').textContent += "@media screen and (min-width:992px) { .nav-menu{ width:"+navwidth+" } .active-nav-menu{ left:"+logowidth+" }}";
	}
	
	/* Smooth anchor scroll */
    jQuery(function () {
        jQuery('a[href*=#]').on('click', function () {
            if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') &&
                location.hostname == this.hostname) {
                var jQuerytarget = jQuery(this.hash);
                jQuerytarget = jQuerytarget.length && jQuerytarget || jQuery('[name=' + this.hash.slice(1) + ']');
                if (jQuerytarget.length) {
                    var targetOffset = jQuerytarget.offset().top - (jQuery("#main-header").outerHeight(true) + 90); //#main-header - заменить на ваш элемент
                    jQuery('html,body').animate({
                        scrollTop: targetOffset
                    }, 1000);
                    return false;
                }
            }
        });
    });

    /* Counterup init */
    jQuery('.counter').counterUp({
        delay: 10,
        time: 3000
    });

    /* Skills animation 1 */
    jQuery(".progress-start-1").waypoint(function () {
        jQuery('.progress-start-1 .skillbar').each(function () {
            jQuery(this).find('.skillbar-bar').animate({
                width: jQuery(this).attr('data-percent')
            }, 2000);
        });
    }, {
        offset: '20%'
    });

    /* Skills animation 2 */
    jQuery(".progress-start-2").waypoint(function () {
        jQuery('.progress-start-2 .skillbar').each(function () {
            jQuery(this).find('.skillbar-bar').animate({
                width: jQuery(this).attr('data-percent')
            }, 2000);
        });
    }, {
        offset: '20%'
    });

    /* Team carousel */
    jQuery('.owl-carousel-team').owlCarousel({
        loop: true,
        margin: 30,
        items: 1,
        nav: true,
        dots: false,
        smartSpeed: 600,
        navContainer: '.team-nav',
        responsive: {
            768: {
                items: 1
            },
            992: {
                items: 2
            },
            1200: {
                items: 3
            }
        }
    })

    /* Testimonials carousel */
    jQuery('.owl-carousel-testimonials').owlCarousel({
        loop: true,
        margin: 30,
        items: 1,
        nav: true,
        dots: false,
        smartSpeed: 600,
        navContainer: '.testimonials-nav',
        responsive: {
            768: {
                items: 1
            },
            992: {
                items: 2
            },
            1200: {
                items: 3
            }
        }
    })

    /* Brands carousel */
    jQuery('.owl-carousel-brands').owlCarousel({
        loop: true,
        margin: 30,
        nav: false,
        dots: false,
        autoplay: true,
        autoplayTimeout: 2000,
        smartSpeed: 600,
        responsive: {
            0: {
                items: 2
            },
            600: {
                items: 3
            },
            1000: {
                items: 4
            }
        }
    })
    
    /* Blog carousel */
    jQuery('.owl-carousel-blog').owlCarousel({
        loop: true,
        margin: 30,
        items: 1,
        nav: true,
        dots: false,
        smartSpeed: 600,
        navContainer: '.blog-nav',
        responsive: {
            768: {
                items: 1
            },
            992: {
                items: 2
            },
            1200: {
                items: 2
            }
        }
    })

    /* Header carousel */
    jQuery('.owl-carousel-header').owlCarousel({
        loop: true,
        items: 1,
        nav: true,
        dots: false,
        animateOut: 'fadeOut',
        animateIn: 'fadeIn',
        navContainer: '.header-nav',
		autoWidth:true,
    })

});