<?php
// **********************************************************************// 
// ! Custom Logo
// **********************************************************************//
function monix_the_custom_logo() {
   if ( function_exists( 'the_custom_logo' ) ) {
      the_custom_logo();
   }
}

// **********************************************************************// 
// ! Custom Is Blog
// **********************************************************************//
function monix_is_blog() {
	if ( (is_archive()) || (is_author()) || (is_category()) || (is_home()) || (is_single()) || (is_tag()) ) {
		return true;
	}
	else {
		return false; 
	}
}

function monix_is_only_blog() {
	if ((is_home()))  {
		return true;
	}
	else {
		return false; 
	}
}
/// Is Blog END ///

// **********************************************************************// 
// ! Custom Is Front Page
// **********************************************************************//
function monix_is_front() {
	if ( !(is_home()) && !(is_single()) && (is_front_page()) ) {
		return true;
	}
	else {
		return false; 
	}
}

// **********************************************************************// 
// ! Excerpt and Content Limit
// **********************************************************************//
function monix_excerpt($category_excerpt_limit) {
      $excerpt = explode(' ', get_the_excerpt(), $category_excerpt_limit);

      if (count($excerpt) >= $category_excerpt_limit) {
          array_pop($excerpt);
          $excerpt = implode(" ", $excerpt) . '...';
      } else {
          $excerpt = implode(" ", $excerpt);
      }

      $excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);

      return $excerpt;
}

function monix_content($category_excerpt_limit) {
    $content = explode(' ', get_the_content(), $category_excerpt_limit);

    if (count($content) >= $category_excerpt_limit) {
        array_pop($content);
        $content = implode(" ", $content) . '...';
    } else {
        $content = implode(" ", $content);
    }

    $content = preg_replace('/\[.+\]/','', $content);
    $content = apply_filters('the_content', $content); 
    $content = str_replace(']]>', ']]&gt;', $content);

    return $content;
}
// **********************************************************************// 
// ! Getting Theme Fonts
// **********************************************************************//
// ! Raleway and Nunito Font
function monix_fonts_nunito_and_railway_url() {
$fonts_url = '';
 
$font_families[] = 'Raleway:300,500,600,900|Nunito:200,300,400,600,700,800,900';
 
$query_args = array(
'family' => urlencode( implode( '|', $font_families ) ),
);
 
$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
 
return esc_url_raw( $fonts_url );
}

// ! Montserrat Font
function monix_fonts_montserrat_url() {
$fonts_url = '';
 
$font_families[] = 'Montserrat:200,300,400,500,500i,600,700,800';
 
$query_args = array(
'family' => urlencode( implode( '|', $font_families ) ),
);
 
$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
 
return esc_url_raw( $fonts_url );
}

// **********************************************************************// 
// ! Custom Walker for wp_nav_menu()
// **********************************************************************//
class monix_walker_nav_menu extends Walker_Nav_Menu {

private $blog_sidebar_pos = "";
// add classes to ul sub-menus
public function start_lvl( &$output, $depth = 0, $args = Array() ) {
    // depth dependent classes
    $indent = str_repeat( "\t", $depth );
	$display_depth = ( $depth + 1); // because it counts the first submenu as 0
    $classes = array(
        ( $display_depth == 1  ? 'dm-align-2' : '' ),
		( $display_depth % 2  ? 'menu-odd sub-menu' : 'menu-even sub-menu' ),
        ( $display_depth >=2 ? '' : '' ),
        'menu-depth-' . $display_depth
        );
    $class_names = implode( ' ', $classes );
	$output .= "\n$indent<ul role=\"menu\" class=\"$class_names\" >\n";
}
  
// add main/sub classes to li's and links
public function start_el( &$output, $item, $depth = 0, $args = Array(), $id = 0 ) {
    global $wp_query;
	$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
  
    /**
			 * Dividers, Headers or Disabled
			 * =============================
			 * Determine whether the item is a Divider, Header, Disabled or regular
			 * menu item. To prevent errors we use the strcasecmp() function to so a
			 * comparison that is not case sensitive. The strcasecmp() function returns
			 * a 0 if the strings are equal.
			 */
			if ( 0 === strcasecmp( $item->attr_title, 'divider' ) && 1 === $depth ) {
				$output .= $indent . '<li role="presentation" class="divider">';
			} elseif ( 0 === strcasecmp( $item->title, 'divider' ) && 1 === $depth ) {
				$output .= $indent . '<li role="presentation" class="divider">';
			} elseif ( 0 === strcasecmp( $item->attr_title, 'dropdown-header' ) && 1 === $depth ) {
				$output .= $indent . '<li role="presentation" class="dropdown-header">' . esc_attr( $item->title );
			} elseif ( 0 === strcasecmp( $item->attr_title, 'disabled' ) ) {
				$output .= $indent . '<li role="presentation" class="disabled"><a href="#">' . esc_attr( $item->title ) . '</a>';
			} else {
				$value = '';
				$class_names = $value;
				$classes = empty( $item->classes ) ? array() : (array) $item->classes;
				$classes[] = 'menu-item-' . $item->ID .' nav-item';
				$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
					
				if ( $args->has_children ) {
					$class_names .= ' dropdown dropdown-v1';
				}
				if ( in_array( 'current-menu-item', $classes, true ) ) {
					$class_names .= ' active';
	
				}
				$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';
				$id = apply_filters( 'nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args );
				$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';
				$output .= $indent . '<li ' . $id . $value . $class_names . '>';
				$atts = array();

				if ( empty( $item->attr_title ) ) {
					$atts['title']  = ! empty( $item->title )   ? strip_tags( $item->title ) : '';
				} else {
					$atts['title'] = $item->attr_title;
				}

				$atts['target'] = ! empty( $item->target ) ? $item->target : '';
				$atts['rel']    = ! empty( $item->xfn )    ? $item->xfn    : '';
				$home_url = home_url();
				// If item has_children add atts to a.
				if ( $args->has_children && 0 === $depth && empty( $item->url ) ) {
					$atts['href']           = '#';
					$atts['data-toggle']    = 'dropdown';
					$atts['class']          = '';
					$atts['aria-haspopup']  = 'true';
				} elseif ( $args->has_children && 0 === $depth && ! empty( $item->url ) ) {
					$atts['href']           = $item->url;
					$atts['class']          = '';
					$atts['aria-haspopup']  = 'true';
				} elseif ( $args->has_children && 1 === $depth && ! empty( $item->url ) ) {
					$atts['href']           = $item->url;
					$atts['class']          = 'sub-arrow';
					$atts['aria-haspopup']  = 'true';
				} elseif ( (! empty( $item->url )) && ($atts['title'] == 'onepage') && ( !monix_is_front() ) ) {
					//For OnePage functionality only; Users should put onepage in the "title attribute" of the menus.
					$atts['href'] = $home_url .'/'. $item->url;
				} else {
					$atts['href'] = ! empty( $item->url ) ? $item->url : '';
				}
				$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );
				$attributes = '';
				foreach ( $atts as $attr => $value ) {
					if ( ! empty( $value ) ) {
						$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
						$attributes .= ' ' . $attr . '="' . $value . '"';
					}
				}
				$item_output = $args->before;

				/*
				 * Glyphicons/Font-Awesome
				 * ===========
				 * Since the the menu item is NOT a Divider or Header we check the see
				 * if there is a value in the attr_title property. If the attr_title
				 * property is NOT null we apply it as the class name for the glyphicon.
				 */
				 
				if( 'mega-menu' == $item->object ){
				$megamenu_item = get_post( $item->object_id );
				$item_output .= '' . apply_filters( 'the_content', $megamenu_item->post_content ) . '';
				}else{
			
				if ( ! empty( $item->attr_title ) && $item->attr_title != 'onepage' ) { // This (&& $item->attr_title != 'onepage') is for OnePage functionality only
					$pos = strpos( esc_attr( $item->attr_title ), 'glyphicon' );
					if ( false !== $pos ) {
						$item_output .= '<a' . $attributes . '><span class="glyphicon ' . esc_attr( $item->attr_title ) . '" aria-hidden="true"></span>&nbsp;';
					} else {
						$item_output .= '<a' . $attributes . '><i class="' . esc_attr( $item->attr_title ) . '" aria-hidden="true"></i>&nbsp;';
					}
				} else {
					$item_output .= '<a' . $attributes . ' class="nav-link">';
				}
				if ( ! empty( $item->title ) && ! empty( $item->ID ) ) {
				$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
				}
				if ( $args->has_children && 0 === $depth ){
				$item_output .= '</a>';
				} elseif ( $args->has_children && 1 === $depth ){ //detecting sub-menu's sub-menu
				$item_output .= '</a>';
				} else {
				$item_output .= '</a>';
				}
				$item_output .= $args->after;
				}
				$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
				
				
			} // End if().
		}
		
		public function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output ) {
			if ( ! $element ) {
				return; }
			$id_field = $this->db_fields['id'];
			// Display this element.
			if ( is_object( $args[0] ) ) {
				$args[0]->has_children = ! empty( $children_elements[ $element->$id_field ] ); }
			parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
		}
} //End Walker_Nav_Menu


// **********************************************************************// 
// ! Get Global Variables
// **********************************************************************//
function monix_get_global_post() {
    global $post;
    if ( 
        ! $post instanceof \WP_Post
    ) {
        return false;
    }
    return $post;
}

function monix_get_global_wpquery() {
    global $wp_query;
    return $wp_query;
}

function monix_get_global_numpages() {
    global $numpages;
    return $numpages;
}

// **********************************************************************// 
// ! Set Content Width
// **********************************************************************// 
if (!isset($content_width)) { $content_width = 825; }

// **********************************************************************// 
// ! Custom Is Blog Only
// **********************************************************************//
function monix_is_blog_only() {
	if ( (is_archive()) || (is_author()) || (is_category()) || (is_home()) || (is_tag()) || (is_search()) ) {
		return true;
	}
	else {
		return false; 
	}
}

function monix_is_single_only() {
	if ( (is_singular()) && (!is_page_template('page-vc.php')) ) {
		return true;
	}
	else {
		return false; 
	}
}
// **********************************************************************// 
// ! Adding Conditional Class to Body
// **********************************************************************//
add_filter( 'body_class', 'monix_body_custom_class' );
function monix_body_custom_class( $classes ) {

	$monix_font_style = monix_get_option('monix_font_style');
	if($monix_font_style == 1){
        $classes[] = 'montserrat_font';
    } else {
		$classes[] = '';
	}
	if(monix_is_blog_only()){
        $classes[] = 'ft_blog_page';
    } else {
		$classes[] = '';
	}
	if(monix_is_single_only()){
        $classes[] = 'ft_single_page';
    } else {
		$classes[] = '';
	}
    return $classes;
}

// **********************************************************************// 
// ! Custom Pagination
// **********************************************************************//
function monix_custom_pagination()
{
	global $wp_query;

	$big = 999999999; // need an unlikely integer
		
	echo paginate_links( array(
		'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
		'format' => '?paged=%#%',
		'current' => max( 1, get_query_var('paged') ),
		'total' => $wp_query->max_num_pages,
		'show_all'     => false,
		'end_size'     => 1,
		'mid_size'     => 2,
		'prev_next'    => true,
		'prev_text'    => '&laquo;',
		'next_text'    => '&raquo;',
		'type'         => 'list',
		'add_args'     => false,
		'add_fragment' => ''
	) ); 
}

// **********************************************************************// 
// ! Pagination without loading
// **********************************************************************//

function monix_pagination_without_loading() {
echo "
	<script>
	jQuery(function(jQuery) {
	jQuery('#pagiloader').hide();	
    jQuery('.content').on('click', '.page-numbers a', function(e){
        e.preventDefault();
        var link = jQuery(this).attr('href');
        jQuery('.content').fadeOut(1500, function(){
			jQuery('#pagiloader').show();
			jQuery('html, body').animate({
			scrollTop: jQuery('#full-blog-section').offset().top - 100
		}, 1000);
            jQuery(this).load(link + ' .content', function() {
				jQuery('#pagiloader').hide();
                jQuery(this).fadeIn(1500);
            });
        });
    });
});
</script>
";
}

// **********************************************************************// 
// ! Newsletter without loading
// **********************************************************************//
function monix_newsletter_without_loading(){
$theme_directory = get_template_directory();
$subscribe_file  = '/subscribe/sub_check.jpg';	
if ( file_exists( $theme_directory . $subscribe_file ) ) {
$subscribe_php = get_template_directory_uri(). '/subscribe/subscribe2.php';
} else {
$subscribe_php = '#';
}
 ?>
        <script>
            jQuery(document).ready(function(){
                jQuery('#newsletter').on("submit", function(e){
                    //Stop the form from submitting itself to the server.
                    e.preventDefault();
					var data = {};                 
                    var email = jQuery("#newsletter-email").val();
                    jQuery.ajax({
                        type: "POST",
						dataType: 'json',
						  beforeSend: function(){
							jQuery(".newsletter-loader").css("visibility", "visible");
						  },
                        url: "<?php echo esc_url($subscribe_php); ?>",
                        data: {email1:email},
						complete: function(){
							jQuery("#newsletter")[0].reset();
							jQuery(".newsletter-loader").css("visibility", "hidden");
						  },
                        success: function(data){
						jQuery('#output').html(data);
                        },	
						error: function(data){
						jQuery('#output').html('Sorry, Something is wrong. Try again later.');
						  },
					  
                    });
                });
            });
        </script>
<?php 
}

// **********************************************************************// 
// ! Display Comments section
// **********************************************************************//
if ( ! function_exists( 'monix_comment' ) ) {
/**
 * Template for comments and pingbacks.
 *
 * To override this walker in a child theme without modifying the comments template
 * simply create your own monix_comment(), and that function will be used instead.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 */
	function monix_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;

	global $post;
	?>
	
	<li class="the-c-list"><article>
	                    <div <?php comment_class("item"); ?> id="comment-<?php comment_ID() ?>">
                        <div class="testimonial">
						<div class="row">
						
						<div class="col-lg-2 sm-noshow">
						<div class="user-name">
                                <div class="user"><?php echo get_avatar($comment, 50); ?></div>     
                            </div>
						</div>
						<div class="col-lg-10 col-md-12 col-sm-12 col-xs-12">
						<div class="dialog">
								<p class="m-0 bold author_info"><?php comment_author(); ?></p>
                                <p class="m-0 bold author_info"><time><?php comment_date('d M, Y') ?></time></p>
							<div class="comment-meta author_info">
							<?php comment_reply_link(array_merge( $args, array(
							'reply_text' => '<i class="fas fa-reply"></i>',
							'depth' => $depth, 
							'max_depth' => $args['max_depth']
							))); ?>
							</div>
                                <p class="light thin mb-30 mt-30"><?php comment_text()?></p>
                            </div>
						</div>
						</div>

                        </div>
                    </div>

	</article>
	<!-- #comment-## -->

	<?php
	}
}

/*******************
Comment form styling
*******************/
if ( ! function_exists( 'monix_modify_comment_fields' ) ) {
	function monix_modify_comment_fields($fields) {

    $fields['fields'] = '<div class="row"><div class="col-sm-6"><div class="form-group">
                      <input type="text" id="author" name="author"  placeholder="'.esc_attr__("Name*", "monix").'"';
	$n_value = '';
	$e_value = '';

	$fields['fields'] .= ' value="'.esc_attr($n_value).'" aria-required="true" /></div></div>
						  <div class="col-sm-6"><div class="form-group">';
    $fields['fields'] .= '<input type="email" id="email_address" name="email"  placeholder="'.esc_attr__("Email*", "monix").'" value="'.esc_attr($e_value).'" aria-required="true" /></div></div>';
	return $fields;
	}
}

add_filter('comment_form_defaults', 'monix_modify_comment_fields');//Name, Email and Website fields customization filter

if ( !is_user_logged_in() ) { 
if ( ! function_exists( 'monix_comment_field' ) ) {
	function monix_comment_field($arg) {
  
	$arg['comment_field'] = '
								<div class="col-sm-12"><div class="form-group">
								<textarea name="comment" id="comment" rows="10"  placeholder="'.esc_attr__("Your Comment", "monix").'"></textarea></div></div>
							 ';    
	return $arg;
	}
}
add_filter('comment_form_defaults', 'monix_comment_field');//Text area customization filter
} else {
if ( ! function_exists( 'monix_comment_field' ) ) {
	function monix_comment_field($arg) {
  
	$arg['comment_field'] = '
								<div class="col-md-12 col-sm-12 nopadding"><div class="form-group">
								<textarea name="comment" id="comment" rows="10"  placeholder="'.esc_attr__("Your Comment", "monix").'"></textarea></div></div>
							 ';    
	return $arg;
	}
}
add_filter('comment_form_defaults', 'monix_comment_field');//Text area customization filter
}

if ( !is_user_logged_in() ) {
function monix_comment_form_submit_button($button) {
	$button =
		'
            <div class="col-sm-6">
                <button name="submit" type="submit" id="[args:id_submit]" value="[args:label_submit]" class="load-more-btn bg-color-1 relative_p"><i class="fa fa-paper-plane"></i> '.esc_attr__("Send Message", "monix").'</button>
            </div> <!-- End col-sm-6 -->
			</div><!--End row-->
         ';// .
		//get_comment_id_fields();
	return $button;
}
add_filter('comment_form_submit_button', 'monix_comment_form_submit_button');//Submit button customization filter
} else {
function monix_comment_form_submit_button($button) {
	$button =
		'
            <div class="col-sm-6 row">
                <button name="submit" type="submit" id="[args:id_submit]" value="[args:label_submit]" class="load-more-btn bg-color-1 relative_p"><i class="fa fa-paper-plane"></i> '.esc_attr__("Send Message", "monix").'</button>
            </div> <!-- End col-sm-6 -->
         ';// .
		//get_comment_id_fields();
	return $button;
}
add_filter('comment_form_submit_button', 'monix_comment_form_submit_button');//Submit button customization filter
}

function monix_move_comment_field_to_bottom( $fields ) {
$comment_field = $fields['comment'];
unset( $fields['comment'] );
$fields['comment'] = $comment_field;

return $fields;
}
add_filter( 'comment_form_fields', 'monix_move_comment_field_to_bottom' );//move the comment text field to the bottom


// **********************************************************************// 
// ! Page Header Function
// **********************************************************************//
function monix_page_heading_function() {
$monix_global_post = monix_get_global_post();
$postid = $monix_global_post->ID;
// Retrieves the stored value from the database
$monix_page_heading_one_meta = get_post_meta( $postid, 'monix_page_heading_one', true );
$monix_page_heading_two_meta = get_post_meta( $postid, 'monix_page_heading_two', true );
$allowed_html_array = array(
					'b' => array(),
					'br' => array(),
					'span' => array('class' => array()),
					);	
if(is_page() && !(is_front_page())){ ?>

    <header class="header-2">
            <div class="item">
                <div class="bg-image animation-zoom" <?php 	if(monix_get_option('monix_page_heading_bg_image') !=''){ ?>
	style="background-image: url(<?php echo esc_url(monix_get_option('monix_page_heading_bg_image')); ?>); background-position: center"
	<?php }else{ ?>
	style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/images/interface/img.jpg); background-position: center"	
	<?php } ?> ></div>
                <div class="overlay-2"></div>
                <div class="container">
                    <div class="row">
					<?php if(is_page()){ ?>
						<?php if(!empty($monix_page_heading_one_meta) || !empty($monix_page_heading_two_meta)){ ?>
							<div class="col-12 header-2-title text-center">
						<?php if(!empty($monix_page_heading_one_meta)){?>	
                            <p class="white light thin sup-title mb-15"><?php echo esc_attr($monix_page_heading_one_meta);?></p>
						<?php } ?>	
						<?php if(!empty($monix_page_heading_two_meta)){?>
                            <p class="p-header white thin uppercase"><?php echo esc_attr($monix_page_heading_two_meta);?></p>	
						<?php } ?>							
							</div>
						<?php } else { ?>
						<div class="col-12 header-2-title text-center">
                            <p class="p-header white thin uppercase"><?php echo esc_attr(single_post_title()); ?></p>							
							</div>						
						<?php } ?>
						<?php } ?>							
	
                    </div>
                </div>
            </div>
    </header>	
<?php
} elseif(is_home()) {
?>
    <header class="header-2">
    <div class="item">
    <div class="bg-image animation-zoom" <?php 	if(monix_get_option('monix_blog_page_heading_bg_image') !=''){ ?>
	style="background-image: url(<?php echo esc_url(monix_get_option('monix_blog_page_heading_bg_image')); ?>); background-position: center"
	<?php }else{ ?>
	style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/images/interface/img.jpg); background-position: center"	
	<?php } ?> ></div>
                <div class="overlay-2"></div>
                <div class="container">
                    <div class="row">
                        <div class="col-12 header-2-title text-center">
						<?php if(monix_get_option('monix_blog_page_heading_title_one') != ''){ ?>
                            <p class="white light thin sup-title mb-15"><?php echo esc_attr(monix_get_option('monix_blog_page_heading_title_one')); ?></p>
						<?php } else { ?>
                            <p class="white light thin sup-title mb-15"><?php echo esc_attr(get_bloginfo('description')); ?></p>						
						<?php } ?>
						<?php if(monix_get_option('monix_blog_page_heading_title_two') != ''){ ?>
                            <p class="p-header white thin"><?php echo wp_kses(monix_get_option('monix_blog_page_heading_title_two'),$allowed_html_array); ?></p>
						<?php } else { ?>	
                            <p class="p-header white thin uppercase"><?php echo esc_attr(get_bloginfo('name')); ?></p>
						<?php } ?>

                        </div>
                    </div>
                </div>
            </div>
        </header>
<?php	
}elseif(is_front_page()){
?>
    <header class="header-2">
    <div class="item">
    <div class="bg-image animation-zoom" <?php 	if(monix_get_option('monix_page_heading_bg_image') !=''){ ?>
	style="background-image: url(<?php echo esc_url(monix_get_option('monix_page_heading_bg_image')); ?>); background-position: center"
	<?php }else{ ?>
	style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/images/interface/img.jpg); background-position: center"	
	<?php } ?> ></div>
                <div class="overlay-2"></div>
                <div class="container">
                    <div class="row">
                        <div class="col-12 header-2-title text-center">
                            <p class="white light thin sup-title mb-15"><?php echo esc_attr(get_bloginfo('description')); ?></p>
                            <p class="p-header white thin uppercase"><?php echo esc_attr(get_bloginfo('name')); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </header>
<?php		
}elseif(is_single()){
?>	
	<header class="header-2">
    <div class="item">
    <div class="bg-image animation-zoom" <?php 	if(monix_get_option('monix_single_post_heading_bg_image') !=''){ ?>
	style="background-image: url(<?php echo esc_url(monix_get_option('monix_single_post_heading_bg_image')); ?>); background-position: center"
	<?php }else{ ?>
	style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/images/interface/img.jpg); background-position: center"	
	<?php } ?> ></div>
                <div class="overlay-2"></div>
                <div class="container">
                    <div class="row">
							<div class="col-12 header-2-title text-center">
							<p class="white light thin sup-title mb-15"><?php esc_html_e('Post','monix'); ?></p>
                            <p class="p-header white thin uppercase"><?php esc_html_e('Single Post','monix'); ?></p>
							</div>
                    </div>
                </div>
            </div>
        </header>
<?php		
}elseif(is_archive() || is_category() || is_author() || is_search()){?>
    <header class="header-2">
            <div class="item">
                <div class="bg-image animation-zoom" <?php 	if(monix_get_option('monix_blog_page_heading_bg_image') !=''){ ?>
	style="background-image: url(<?php echo esc_url(monix_get_option('monix_blog_page_heading_bg_image')); ?>); background-position: center"
	<?php }else{ ?>
	style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/images/interface/img.jpg); background-position: center"	
	<?php } ?> ></div>
                <div class="overlay-2"></div>
                <div class="container">
                    <div class="row">
					<?php if((is_archive()) && !(is_category()) && !(is_author())) { ?>
                        <div class="col-12 header-2-title text-center">
                            <p class="white light thin sup-title mb-15"><?php esc_html_e('Posts from Archive:','monix');?></p>
                            <p class="p-header white thin uppercase"><?php echo esc_attr(get_the_archive_title()); ?></p>
                        </div>
					<?php } elseif(is_category()) { ?>	
					    <div class="col-12 header-2-title text-center">
                            <p class="white light thin sup-title mb-15"><?php esc_html_e('Posts from Category:','monix');?></p>
                            <p class="p-header white thin uppercase"><?php echo esc_attr(single_cat_title()); ?></p>							
                        </div>
						<?php } elseif(is_author()) { ?>
					    <div class="col-12 header-2-title text-center">
						<?php if(!empty(the_author_meta('user_description'))) {?>
                            <p class="white light thin sup-title mb-15"><?php  echo esc_attr(the_author_meta('user_description')); ?></p>
						<?php } ?>
                
											
                            <p class="p-header white thin uppercase"><?php echo esc_attr(get_the_author_meta('user_firstname').' '. get_the_author_meta('user_lastname')); ?></p>							
                        </div>						
						<?php } elseif (is_search()){ ?>							
						<div class="col-12 header-2-title text-center">
                            <p class="p-header white thin uppercase"><?php esc_html_e('Search Result', 'monix'); ?></p>							
						</div>		
						<?php } else { ?>		
							<div class="col-12 header-2-title text-center">
                            <p class="p-header white thin uppercase"><?php echo esc_attr(single_post_title()); ?></p>							
							</div>							
						<?php } ?>
                    </div>
                </div>
            </div>
    </header>
<?php	
}
}
/// Page Header End ///

// **********************************************************************// 
// ! Selected Page IDs Function
// **********************************************************************//
function monix_check_pageselect_function() {
	$pages_array = monix_get_option('monix_check_pageselect');
		$output = '';
		foreach($pages_array as $page) {
			$output .= ''.$page.',';
		}
		$new = rtrim($output,", ");
	return $new;
}

// **********************************************************************// 
// ! Breadcrumb Function Start
// **********************************************************************//
function monix_page_breadcrumb_function() {
if(!(is_front_page())){		
?>
        <!-- Breadcrumb -->
        <div class="crumb bg-color-1">
            <div class="container">
                <ol class="d-flex justify-content-center">                    
                    <?php monix_get_breadcrumb() ;?>
                </ol>
            </div>
        </div>
        <!-- Breadcrumb end -->
<?php
}	
}

function monix_get_breadcrumb() {
$monix_global_post = monix_get_global_post();
$postid = $monix_global_post->ID;
$postcat = get_the_category($postid);	
?>
<li><a href="<?php echo esc_url(get_home_url()); ?>"><?php esc_html_e('Home','monix');?></a></li>
<li><a href="#" class="separator">/</a></li>
<?php	
    if (is_category()) {
?>		
<li><span><?php echo esc_attr(single_cat_title());?></span></li>
<?php
    } elseif (is_page()) {
?>		
<li><span><?php echo esc_attr(single_post_title());?></span></li>
<?php
    } elseif (is_home()) {
?>		
<li><span><?php echo esc_attr(single_post_title());?></span></li>
<?php
} elseif (is_search()) {
?>	
<li><span><?php esc_html_e('Search Results for: ','monix');?><?php echo esc_attr(the_search_query());?></span></li>		
<?php		
    } elseif(is_single()){
?>	
<li><a href="<?php echo get_permalink( get_option( 'page_for_posts' ) ); ?>"><?php esc_html_e('Blog','monix');?></a></li>
<li><a href="#" class="separator">/</a></li>
<li><span><?php echo esc_attr( $postcat[0]->name);?></span></li>	
<?php		
	} elseif(is_archive() && !(is_author())){
?>
<li><span><?php echo esc_attr(get_the_archive_title());?></span></li>
<?php		
	}elseif(is_author()){
?>
<li><span><?php echo esc_attr(get_the_author_meta('display_name'));?></span></li>
<?php		
	}
}
// **********************************************************************// 
// ! End Breadcrumb Function
// **********************************************************************//

// **********************************************************************// 
// ! Start Social Sharing Button for Post
// **********************************************************************//
function monix_social_sharing_buttons() {
		$post = monix_get_global_post();
		
		// Get current post URL 
		$monixURL = urlencode(get_permalink());
 
		// Get current post title
		$monixTitle = htmlspecialchars(urlencode(html_entity_decode(get_the_title(), ENT_COMPAT, 'UTF-8')), ENT_COMPAT, 'UTF-8');
		// $monixTitle = str_replace( ' ', '%20', get_the_title());
		
		// Get Post Thumbnail for pinterest
		$monixThumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
		
		$twitter_username=monix_get_option('social_twitter_username');
		
		// sharing URL 
		$twitterURL = 'https://twitter.com/intent/tweet?text='.$monixTitle.'&amp;url='.$monixURL.'&amp;via='.$twitter_username;
		$facebookURL = 'https://www.facebook.com/sharer/sharer.php?u='.$monixURL;
		$googleURL = 'https://plus.google.com/share?url='.$monixURL;

		$linkedInURL = 'https://www.linkedin.com/shareArticle?mini=true&url='.$monixURL.'&amp;title='.$monixTitle;
		$pinterestURL = 'https://pinterest.com/pin/create/button/?url='.$monixURL.'&amp;media='.$monixThumbnail[0].'&amp;description='.$monixTitle;
 
		$content = '<ul class="share">';
		$content .= '<li class=" right share-text">'.esc_attr__("Share", "monix").' <span class="noshow-max400">'.esc_attr__("this post", "monix").'</span> :</li>';
		$content .= '<li><a href="'. $facebookURL .'" target="_blank"><i class="fab fa-facebook-f bg-color-4 bg-color-1-hover"></i></a></li>';		
		$content .= '<li><a href="'. $twitterURL .'" target="_blank"><i class="fab fa-twitter bg-color-4 bg-color-1-hover"></i></a></li>';		
		$content .= '<li><a href="'. $googleURL .'" target="_blank"><i class="fab fa-google-plus-g bg-color-4 bg-color-1-hover"></i></a></li>';
		$content .= '<li><a href="'. $linkedInURL .'" target="_blank"><i class="fab fa-linkedin-in bg-color-4 bg-color-1-hover"></i></a></li>';
		$content .= '<li><a href="'. $pinterestURL .'" target="_blank"><i class="fab fa-pinterest-p bg-color-4 bg-color-1-hover"></i></a></li>';
		$content .= '</ul>';
	
	
	return $content;
}