<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- Color of address bar in mobile browser -->
    <meta name="theme-color" content="#E56734">
	<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	
	<!-- Favicon -->
	<?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
	if(monix_get_option('monix_favicon') != '') { ?>
    <link rel="shortcut icon" href="<?php echo esc_url( monix_get_option('monix_favicon') ); ?>">
	<?php } } ?>
	
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if(monix_get_option('monix_preloader') == '1') { ?>
    <!-- Preloader -->
    <div class="preloader">
        <div class="load-icon">
		<?php if(monix_get_option('monix_preloader_icon') != '') { ?>
            <!-- Icon -->
            <div class="icon" style="background-image: url(<?php echo esc_url(monix_get_option('monix_preloader_icon')); ?>);"></div>
		<?php }else{ ?>	
		<!-- Icon -->
            <div class="icon" style="background-image: url(<?php echo esc_url(get_template_directory_uri());?>/images/icons/icon.png);"></div>
		<?php } ?>	
		<?php if(monix_get_option('monix_preloader_text') != '') { ?>
            <p class="white thin"><?php echo esc_attr(monix_get_option('monix_preloader_text')); ?></p>
		<?php } else { ?>
		<p class="white thin"><?php esc_html_e('Loading...','monix');?></p>	
		<?php } ?>		
        </div>
    </div>
   <!--  Preloader end -->
<?php } ?>  
   <!-- Page-->
    <div class="page-wrap" id="top">
        <!-- Navigation -->
        <!-- Use manual or automatic closing. class="manual" or class="auto" -->
        <nav class="auto">
            <div class="navigation bg-color-4" id="logo_img">
			<?php if(monix_get_option('logo_icon') != '' || monix_get_option('logo_text') != '') { ?>
                <!-- Logo -->
                <a href="<?php if(monix_get_option('logo_link') != '') { echo esc_url(monix_get_option('logo_link'));}else{ echo esc_url( home_url() ); } ?>" class="logo-nav">
					<?php if(monix_get_option('logo_icon') != '') { ?>
                    <div><img src="<?php echo esc_url(monix_get_option('logo_icon'));?>" alt="logo" class="icon"></div>
					<?php } ?>
					<?php if(monix_get_option('logo_text') != '') { ?>
                    <div>
                        <p class="logo-text white"><?php echo esc_attr(monix_get_option('logo_text')); ?></p>
                    </div>
					<?php } ?>
                </a>
                <!-- Logo end -->
			<?php } else { 		
			$custom_logo_id = get_theme_mod( 'custom_logo' );
			$logo = wp_get_attachment_image_src( $custom_logo_id , 'full' );
			?>
				 <a href="<?php echo esc_url( home_url() ); ?>" class="logo-nav">
					<?php if(monix_the_custom_logo()){ ?>
							<div><img src="<?php echo esc_url( $logo[0] );?>" alt="logo" class="icon"></div>
					<?php } else { ?>			
							<div><img src="<?php echo esc_url( get_template_directory_uri() ).'/images/'; ?>icons/i-logo.svg" alt="logo" class="icon"></div>
							<div>
								<p class="logo-text white"><?php esc_html_e('Monix','monix');?></p>
							</div>
					<?php } ?>
				</a>
			<?php  } ?>
			<?php 
			
			$selected_pages = monix_check_pageselect_function();
			$pages_array = explode(",",$selected_pages);
			if ( is_home() || is_front_page() || is_page($pages_array) ) {
			// home or front page
			?>
				<!-- Burger button -->
                <div class="open-button">
                    <div class="burger">
                        <div class="burger-brick"></div>
                        <div class="burger-brick middle"></div>
                        <div class="burger-brick"></div>
                    </div>
                </div>
                <!-- Burger button end -->		
			<?php } else { ?>
                <!-- Back to home button -->
                <div class="back-to-home">
                    <div class="back-btn"  onclick="window.history.back()"><i class="fas fa-arrow-left"></i></div>
                </div>
             <!-- Back to home button end -->	
			<?php } ?>	
            </div>
            <!-- Menu -->
            <div class="nav-menu<?php if ( is_page($pages_array) ) { ?> custom-wdth<?php } ?> bg-color-4 <?php if ( !is_home() && !is_front_page() && !is_page($pages_array)) { ?>the_inner<?php } ?>">
                    <?php
						if ( has_nav_menu('monix_primary_menu') ) {
						wp_nav_menu( array(
							'theme_location'    => 'monix_primary_menu',
							'container'     => false,
							'container_id'      => '',
							'conatiner_class'   => '',
							'menu_class'        => 'navigation_ul', 
							'echo'          => true,
							'items_wrap'        => '<ul id="%1$s" class="%2$s">%3$s</ul>',
							'depth'         => 10, 
							'walker'        => new monix_walker_nav_menu
						) );
						} else {
						?><p class="white"><?php							
							esc_html_e( 'Setup Your Menu from "Appearance - Menus" page of your WP-Admin Panel' , 'monix' );
						?></p><?php							
						}
					?>
<?php if(!empty(monix_get_option('social_facebook')) || !empty(monix_get_option('social_twitter')) || !empty(monix_get_option('social_linkedin')) || !empty(monix_get_option('social_googleplus')) || !empty(monix_get_option('social_flickr')) || !empty(monix_get_option('social_utube')) || !empty(monix_get_option('social_instagram')) || !empty(monix_get_option('social_wechat'))) { ?>					
                <!-- Social icons -->
                <ul class="mobile-social">
				<?php if(monix_get_option('social_facebook') != '') { ?>
                    <li><a href="<?php echo monix_get_option('social_facebook'); ?>" target="_blank"><i class="fab fa-facebook-square"></i></a></li>
				<?php } ?>	
				<?php if(monix_get_option('social_twitter') != '') { ?>
                    <li><a href="<?php echo monix_get_option('social_twitter'); ?>" target="_blank"><i class="fab fa-twitter-square"></i></a></li>
				<?php } ?>	
				<?php if(monix_get_option('social_linkedin') != '') { ?>				
                    <li><a href="<?php echo monix_get_option('social_linkedin'); ?>" target="_blank"><i class="fab fa-linkedin"></i></a></li>
				<?php } ?>	
				<?php if(monix_get_option('social_googleplus') != '') { ?>				
                    <li><a href="<?php echo monix_get_option('social_googleplus'); ?>" target="_blank"><i class="fab fa-google-plus-square"></i></a></li>
				<?php } ?>	
				<?php if(monix_get_option('social_flickr') != '') { ?>				
                    <li><a href="<?php echo monix_get_option('social_flickr'); ?>" target="_blank"><i class="fab fa-flickr"></i></a></li>
				<?php } ?>	
				<?php if(monix_get_option('social_utube') != '') { ?>				
                    <li><a href="<?php echo monix_get_option('social_utube'); ?>" target="_blank"><i class="fab fa-youtube-square"></i></a></li>
				<?php } ?>	
				<?php if(monix_get_option('social_instagram') != '') { ?>				
                    <li><a href="<?php echo monix_get_option('social_instagram'); ?>" target="_blank"><i class="fab fa-instagram"></i></a></li>
				<?php } ?>	
				<?php if(monix_get_option('social_wechat') != '') { ?>				
                    <li><a href="<?php echo monix_get_option('social_wechat'); ?>" target="_blank"><i class="fab fa-weixin"></i></a></li>
				<?php } ?>					
                </ul>
<?php } ?>			
            </div>
            <!-- Menu end -->
        </nav>
        <!-- Navigation end -->