<?php
// **********************************************************************// 
// ! One Click Demo Content Import
// **********************************************************************// 
function monix_oneclick_import_files() {
  return array(
    array(
      'import_file_name'             => 'Monix',
      'categories'                   => array( 'Portfolio' ),
      'local_import_file'            => trailingslashit( get_template_directory() ) . 'framework/demo-content/demo1/demo-content.xml',
      'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'framework/demo-content/demo1/widgets.wie',
      'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'framework/demo-content/demo1/customizer.dat',
      'import_preview_image_url'     => 'https://fluentthemes.com/wp/apparatus-view-demo/img/PARRALAX_HEADER.jpg',
      'import_notice'                => esc_html__( 'After you import this demo, you will have to import theme-options data separately. Get the Theme-Options Data ', 'monix'). '<a style="font-weight:bold;" target="_blank" href="https://fluentthemes.com/wp/monix-doc/theme-options/theme-options-demo1.html">'.esc_html__('From Here', 'monix').'</a>' . esc_html__( '. Then Copay and Save the data in your PC and you will be able to use that saved data later to import theme-options separately.', 'monix'),
      'preview_url'                  => 'https://fluentthemes.com/wp/monix/',
    ),
  );
}
add_filter( 'pt-ocdc/import_files', 'monix_oneclick_import_files' );

function monix_oneclick_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'monix_primary_menu' => $main_menu->term_id
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home Default' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdc/after_import', 'monix_oneclick_after_import_setup' );