<?php



/* -----------------------------------------------------------------------------

 * Helper Function

 * -------------------------------------------------------------------------- */

function monix_get_option( $opt_name, $default = null ) {

	global $Redux_Options;

	return $Redux_Options->get( $opt_name, $default );

}

/* -----------------------------------------------------------------------------

 * Load Custom Fields

 * -------------------------------------------------------------------------- */

require_once( MONIX_ADMIN_PATH . 'custom-fields/field_font_upload/field_upload.php' );

require_once( MONIX_ADMIN_PATH . 'custom-fields/field_typography.php' );

require_once( MONIX_ADMIN_PATH . 'custom-fields/field_section_info.php' );

require_once( MONIX_ADMIN_PATH . 'custom-fields/field_sidebar_select.php' );

require_once( MONIX_ADMIN_PATH . 'custom-fields/field_color_scheme.php' );

require_once( MONIX_ADMIN_PATH . 'custom-fields/field_slider.php' );

require_once( MONIX_ADMIN_PATH . 'custom-fields/field_slides.php' );

/* -----------------------------------------------------------------------------

 * Initial Redux Framework

 * -------------------------------------------------------------------------- */





if(!class_exists('Redux_Options')) {

	require_once( MONIX_ADMIN_PATH . 'options/defaults.php' );

}

/*

 *

 * Most of your editing will be done in this section.

 *

 * Here you can override default values, uncomment args and change their values.

 * No $args are required, but they can be over ridden if needed.

 *

 */

function monix_setup_framework_options() {

	$args = array();



	$args['std_show'] = true; // If true, it shows the std value



	// Set the class for the dev mode tab icon.

	// This is ilicered unless $args['icon_type'] = 'iconfont'

	// Default: null

	$args['dev_mode_icon_class'] = 'icon-large';



	// Setup custom links in the footer for share icons

	$args['share_icons']['twitter'] = array(

		'link' => 'http://twitter.com/ghost1227',

		'title' => esc_html__('Follow me on Twitter', 'monix'),

		'img' => Redux_OPTIONS_URL . 'img/social/Twitter.png'

	);

	$args['share_icons']['linked_in'] = array(

		'link' => 'http://www.linkedin.com/profile/view?id=52559281',

		'title' => esc_html__('Find me on LinkedIn', 'monix'),

		'img' => Redux_OPTIONS_URL . 'img/social/LinkedIn.png'

	);



	// Set the class for the import/export tab icon.

	// This is ilicered unless $args['icon_type'] = 'iconfont'

	// Default: null

	$args['import_icon_class'] = 'icon-large';



	// Set a custom option name. Don't forget to replace spaces with underscores!

	$args['opt_name'] = 'monix_theme_options';



	// Set a custom title for the options page.

	// Default: Options

	$args['menu_title'] = esc_html__('Theme Options', 'monix');



	// Set a custom page title for the options page.

	// Default: Options

	$args['page_title'] = esc_html__('Theme Options', 'monix');



	// Set a custom page slug for options page (wp-admin/themes.php?page=***).

	// Default: redux_options

	$args['page_slug'] = 'redux_options';



	// Set the menu type. Set to "menu" for a top level menu, or "submenu" to add below an existing item.

	// Default: menu

	$args['page_type'] = 'menu';



	// Set the parent menu.

	// Default: themes.php

	$args['page_parent'] = 'themes.php';



	// Set the icon type. Set to "iconfont" for Font Awesome, or "image" for traditional.

	// Redux no longer ships with standard icons!

	// Default: iconfont

	$args['dev_mode_icon_type'] = 'iconfont';

	$args['import_icon_type'] = 'iconfont';

	$allowed_html_array = array(

    'p' => array(),

    'h4' => array(),

	'strong' => array(),

	'a' => array(),

	);

	$args['intro_text'] = wp_kses( __( '<h4>Theme Settings Information for monix Theme</h4>', 'monix' ), $allowed_html_array );



	$sections = array();

	

	//section for General-logo, favicon, ratina, custom css

	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'globe',

		'icon_class' => 'icon-large',

		'title' => esc_html__('General', 'monix') ,

		'desc' => wp_kses(__('<p class="description">This is the general options.</p>', 'monix') , $allowed_html_array) ,

		'fields' => array(

			array(

				'id' => 'monix_favicon',

				'type' => 'upload',

				'title' => esc_html__('Upload Favicon', 'monix') ,

				'sub_desc' => esc_html__('This is favicon. Upload 64x64 favicon icon.', 'monix') ,

			),

			array(

				'id' => 'monix_preloader',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Page Preloader', 'monix') ,

				'sub_desc' => esc_html__('On/Off Page Loader GIF', 'monix') ,

				'switch' => true,

				'std' => '1'

			),

			array(

				'id' => 'monix_preloader_icon',

				'type' => 'upload',

				'title' => esc_html__('Upload Preloader Icon', 'monix') ,

				'sub_desc' => esc_html__('This is preloader icon. Upload 512x512 png icon.', 'monix') ,

			),

			array(

				'id' => 'monix_preloader_text',

				'type' => 'text',

				'title' => esc_html__('Preloader Text', 'monix') ,

				'sub_desc' => esc_html__('Text for preloader.', 'monix') ,

				'std' => '',

			) ,	

			array(

				'id' => 'monix_preloader_text_color',

				'type' => 'color',

				'title' => esc_html__('Preloader Text Color', 'monix') ,

				'sub_desc' => esc_html__('Text color for preloader.', 'monix') ,

				'std' => '',

			) ,		

			array(

				'id' => 'monix_preloader_bg_color',

				'type' => 'color',

				'title' => esc_html__('Preloader Background Color', 'monix') ,

				'sub_desc' => esc_html__('Background color for preloader.', 'monix') ,

				'std' => '',

			) ,				

		)

	);

	

	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'cog',

		'icon_class' => 'icon-large',

		'title' => esc_html__('Logo Settings', 'monix') ,

		'desc' => wp_kses(__('<p class="description">This is for Logo options.</p>', 'monix') , $allowed_html_array) ,

		'fields' => array(

			array(

				'id' => 'logo_icon',

				'type' => 'upload',

				'title' => esc_html__('Logo Icon', 'monix'),

				'sub_desc' => esc_html__('Upload your site logo here. (512x512 pixel)', 'monix'),

				'std' => '',

			),

			array(

				'id' => 'logo_link',

				'type' => 'text',

				'title' => esc_html__('Link Logo', 'monix'),

				'sub_desc' => esc_html__('Example: http:// . If you want to enable scroll to top, input #top', 'monix'),

				'std' => '',

			),

			array(

				'id' => 'logo_text',

				'type' => 'text',

				'title' => esc_html__('Logo Text', 'monix'),

				'sub_desc' => esc_html__('Enter your site name or the title with logo here.', 'monix'),

				'std' => '',

			),	

			array(

				'id' => 'logo_text_line_height',

				'type' => 'text',

				'title' => esc_html__('Logo Text Line Height', 'monix'),

				'sub_desc' => esc_html__('Enter logo text line height in pixel.Example: 20px', 'monix'),

				'std' => '',

			),

			array(

				'id' => 'logo_text_padding_left',

				'type' => 'text',

				'title' => esc_html__('Logo Text Padding Left', 'monix'),

				'sub_desc' => esc_html__('Enter logo text left padding in pixel.Example: 7px', 'monix'),

				'std' => '',

			),

			array(

				'id' => 'logo_text_font_size',

				'type' => 'text',

				'title' => esc_html__('Logo Text Font Size', 'monix'),

				'sub_desc' => esc_html__('Enter logo text font size in pixel.Example: 20px', 'monix'),

				'std' => '',

			),	

			array(

				'id' => 'logo_text_color',

				'type' => 'color',

				'title' => esc_html__('Logo Text Color', 'monix'),

				'sub_desc' => '',

				'std' => '',

			),				
		)

	);

	//section for menu settings

	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'cog',

		'icon_class' => 'icon-large',

		'title' => esc_html__('Menu Setings', 'monix') ,

		'desc' => wp_kses(__('<p class="description">This is the menu settings options.</p>', 'monix') , $allowed_html_array) ,

		'fields' => array(



			array(

				'id' => 'monix_check_pageselect',

				'type' => 'pages_multi_select',

				'title' => esc_html__('Switch On Main Menu for These Pages', 'monix') ,

				'sub_desc' => esc_html__('By Default only HomePage and Blog Page have the Main Menu', 'monix') ,
				
				'args' => array(
							'post_status' => 'publish'
						),

				'options' => array(),

			),
			
			array(

				'id' => 'main_menu_btn_color',

				'type' => 'color',

				'title' => esc_html__('Main Menu Button Color', 'monix'),

				'sub_desc' => esc_html__('Enter here main menu burger button color', 'monix'),

				'std' => '',

			),	

			array(

				'id' => 'main_menu_bg_color',

				'type' => 'color',

				'title' => esc_html__('Main Menu Background Color', 'monix'),

				'sub_desc' => esc_html__('Enter here main menu Background Color', 'monix'),

				'std' => '',

			),

			array(

				'id' => 'main_menu_anchor_color',

				'type' => 'color',

				'title' => esc_html__('Main Menu Anchor Color', 'monix'),

				'sub_desc' => esc_html__('Enter here main menu anchor title color', 'monix'),

				'std' => '',

			),

			array(

				'id' => 'main_menu_anchor_hover_color',

				'type' => 'color',

				'title' => esc_html__('Main Menu Anchor Hover Color', 'monix'),

				'sub_desc' => esc_html__('Enter here main menu anchor hover color.', 'monix'),

				'std' => '',

			),	

			array(

				'id' => 'main_menu_back_btn_color',

				'type' => 'color',

				'title' => esc_html__('Main Menu Back Button Color', 'monix'),

				'sub_desc' => esc_html__('Enter here main menu back button color.', 'monix'),

				'std' => '',

			),

			array(

				'id' => 'main_menu_width',

				'type' => 'text',

				'title' => esc_html__('Main Menu Width in Desktop Device', 'monix'),

				'sub_desc' => esc_html__('Enter here main menu width in pixel for desktop device. Example: "280px" or use "auto" for long length text.', 'monix'),

				'std' => '',

			),			
			
			array(

				'id' => 'main_menu_expand_width',

				'type' => 'text',

				'title' => esc_html__('Main Menu Expanded Width in Desktop Device', 'monix'),

				'sub_desc' => esc_html__('Enter here main menu width when expanded in pixel or percentage for desktop device. Example: "280px" or "60%".', 'monix'),

				'std' => '',

			),			

			array(

				'id' => 'footer_menu_anchor_color',

				'type' => 'color',

				'title' => esc_html__('Footer Menu Anchor Color', 'monix'),

				'sub_desc' => esc_html__('Enter here footer menu anchor color.', 'monix'),

				'std' => '',

			),	

			array(

				'id' => 'footer_menu_anchor_hover_color',

				'type' => 'color',

				'title' => esc_html__('Footer Menu Anchor Hover Color', 'monix'),

				'sub_desc' => esc_html__('Enter here footer menu anchor hover color.', 'monix'),

				'std' => '',

			),				

		)

	);

	// section for Social icon url



	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'group',

		'icon_class' => 'icon-large',

		'title' => esc_html__('Social Media', 'monix') ,

		'desc' => wp_kses(__('<p class="description">This is options for setting up the social media of website. Do not forget to use http:// for any social urls.</p>', 'monix') , $allowed_html_array) ,

		'fields' => array(

			array(

				'id' => 'social_facebook',

				'type' => 'text',

				'title' => esc_html__('Facebook URL', 'monix') ,

				'sub_desc' => esc_html__('The URL to your account page', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'social_twitter',

				'type' => 'text',

				'title' => esc_html__('Twitter URL', 'monix') ,

				'sub_desc' => esc_html__('The URL to your account page', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'social_twitter_username',

				'type' => 'text',

				'title' => esc_html__('Twitter Username', 'monix') ,

				'sub_desc' => esc_html__('Enter here your twitter username.Example: twitterdev', 'monix') ,

				'std' => 'twitterdev',

			) ,			

			array(

				'id' => 'social_linkedin',

				'type' => 'text',

				'title' => esc_html__('Linkedin URL', 'monix') ,

				'sub_desc' => esc_html__('The URL to your account page', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'social_googleplus',

				'type' => 'text',

				'title' => esc_html__('GooglePlus URL', 'monix') ,

				'sub_desc' => esc_html__('The URL to your account page', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'social_flickr',

				'type' => 'text',

				'title' => esc_html__('Flicker URL', 'monix') ,

				'sub_desc' => esc_html__('The URL to your account page', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'social_utube',

				'type' => 'text',

				'title' => esc_html__('YouTube URL', 'monix') ,

				'sub_desc' => esc_html__('The URL to your account page', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'social_instagram',

				'type' => 'text',

				'title' => esc_html__('Instagram URL', 'monix') ,

				'sub_desc' => esc_html__('The URL to your account page', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'social_wechat',

				'type' => 'text',

				'title' => esc_html__('WeChat URL', 'monix') ,

				'sub_desc' => esc_html__('The URL to your account page', 'monix') ,

				'std' => '',

			) ,

		)

	);



	// section for Footer



	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'columns',

		'icon_class' => 'icon-large',

		'title' => esc_html__('Footer/Contact', 'monix') ,

		'desc' => wp_kses(__('<p class="description">This is options for Footer and Contact.</p>', 'monix') , $allowed_html_array) ,

		'fields' => array(

			array(

				'id' => 'monix_footer_columns',

				'type' => 'radio',

				'title' => esc_html__('Number of Columns in Footer for Front Page', 'monix') ,

				'sub_desc' => esc_html__('How Many Columns You Want for Front Page in Footer?', 'monix') ,

				'options' => array(

					'1' => 'One Column (Insert your Widgets in "1 Column Footer  - Front Page" area from Appearance > Widgets page)',

					'2' => 'Two Columns (Insert your Widgets in "2 Columns Footer  - Front Page" area from Appearance > Widgets page)',

				) , // Must provide key => value pairs for radio options

				'std' => '2'

			),

			array(

				'id' => 'monix_footer_columns_for_blog_page',

				'type' => 'radio',

				'title' => esc_html__('Number of Columns in Footer for All Page Except Front Page', 'monix') ,

				'sub_desc' => esc_html__('How Many Columns You Want for all Page except front page in Footer?', 'monix') ,

				'options' => array(

					'1' => 'One Column (Insert your Widgets in "1 Column Footer  - All Page" area from Appearance > Widgets page)',

					'2' => 'Two Columns (Insert your Widgets in "2 Columns Footer  - All Page" area from Appearance > Widgets page)',

				) , // Must provide key => value pairs for radio options

				'std' => '2'

			),			

			array(

				'id' => 'footer_top_bg_color',

				'type' => 'color',

				'title' => esc_html__('Footer Top Section Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose the color for top footer section.', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'footer_bottom_bg_color',

				'type' => 'color',

				'title' => esc_html__('Copyright Section Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose the background color for footer bottom section.', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'footer_bottom_text_color',

				'type' => 'color',

				'title' => esc_html__('Copyright Section Text Color', 'monix') ,

				'sub_desc' => esc_html__('Choose the text color for footer bottom section.', 'monix') ,

				'std' => '',

			) ,			

			array(

				'id' => 'copy_text',

				'type' => 'textarea',

				'title' => esc_html__('Copyright Text', 'monix') ,

				'sub_desc' => esc_html__('Enter your Copyright text here', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'additional_author_text',

				'type' => 'textarea',

				'title' => esc_html__('Text about Author', 'monix') ,

				'sub_desc' => esc_html__('Enter your text here', 'monix') ,

				'std' => '',

			) ,

		)

	);



	// section for aweber



	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'cog',

		'icon_class' => 'icon-large',

		'title' => esc_html__('MailChimp/Aweber Newsletter', 'monix') ,

		'desc' => wp_kses(__('<p class="description">MailChimp and Aweber settings for footer subscriber form of monix</p>', 'monix') , $allowed_html_array) ,

		'fields' => array(

			array(

				'id' => 'mailchimp_apikey',

				'type' => 'text',

				'title' => esc_html__('MailChimp API Key', 'monix') ,

				'sub_desc' => esc_html__('The unique API Key of your MailChimp account', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'mailchimp_listid',

				'type' => 'text',

				'title' => esc_html__('MailChimp List ID', 'monix') ,

				'sub_desc' => esc_html__('The unique List ID of your MailChimp account', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => '123',

				'type' => 'info',

				'desc' => esc_html__('If you want to use Aweber instead of MailChimp use the settings below and keep the above MailChimp fields empty.', 'monix') ,

			) ,

			array(

				'id' => 'ft_aweber_listid',

				'type' => 'text',

				'title' => esc_html__('Aweber List ID', 'monix') ,

				'sub_desc' => esc_html__('The unique List ID of Aweber account', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'aweber_redirectpage',

				'type' => 'text',

				'title' => esc_html__('Redirect Page URL', 'monix') ,

				'sub_desc' => esc_html__('Redirect page url after submission of Aweber form', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'aweber_redirectpage_old',

				'type' => 'text',

				'title' => esc_html__('Redirect Page URL for already subscribed users', 'monix') ,

				'sub_desc' => esc_html__('Redirect page url for already subscribed users of Aweber', 'monix') ,

				'std' => '',

			) ,

		)

	);



	// section for aweber



	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'cog',

		'icon_class' => 'icon-large',

		'title' => esc_html__('Blog Settings', 'monix') ,

		'desc' => wp_kses(__('<p class="description">Blog Page Settings </p>', 'monix') , $allowed_html_array) ,

		'fields' => array(

			array(

				'id' => 'monix_blog_style',

				'type' => 'radio',

				'title' => esc_html__('Choose Blog Layout', 'monix') ,

				'options' => array(

					'1' => esc_html__('Blog Layout One', 'monix') ,

					'2' => esc_html__('Blog Layout Two', 'monix') ,
					'3' => esc_html__('Blog Layout Three', 'monix') ,

				) , // Must provide key => value pairs for radio options

				'std' => '1'

			) ,

			array(

				'id' => 'monix_blog_page_heading_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Blog Page Heading Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off page heading for page.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),

			array(

				'id' => 'monix_blog_page_heading_bg_image',

				'type' => 'upload',

				'title' => esc_html__('Upload Blog Page Heading Section Background Image', 'monix') ,

				'sub_desc' => esc_html__('upload here image for heading section background.', 'monix') ,

			),

			array(

				'id' => 'monix_blog_page_heading_title_one',

				'type' => 'text',

				'title' => esc_html__('Blog Page Heading Section Title One', 'monix') ,

				'sub_desc' => esc_html__('Enter blog page heading title here.', 'monix') ,

			),

			array(

				'id' => 'monix_blog_page_heading_title_two',

				'type' => 'text',

				'title' => esc_html__('Blog Page Heading Section Title Two', 'monix') ,

				'sub_desc' => esc_html__('Enter blog page heading title here. To bold the text, use <span class="bold">BLOG</span>', 'monix') ,

			),

			array(

				'id' => 'monix_blog_page_breadcrumb_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Blog Page Breadcrumb Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off page Breadcrumb for blog page.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),	

			array(

				'id' => 'monix_blog_page_breadcrumb_bg_color',

				'type' => 'color',

				'title' => esc_html__('Blog Breadcrumb Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose the background color for blog breadcrumb  section.', 'monix') ,

				'std' => '',

			) ,	

			array(

				'id' => 'monix_blog_comment_info',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Blog Post Comments Meta', 'monix') ,

				'sub_desc' => esc_html__('On/Off blog page post Comments Meta', 'monix') ,

				'switch' => true,

				'std' => '0'

			),
			
			array(

				'id' => 'monix_blog_date_info',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Blog Page Post Date Meta', 'monix') ,

				'sub_desc' => esc_html__('On/Off blog page post date Meta', 'monix') ,

				'switch' => true,

				'std' => '1'

			),	

			array(

				'id' => 'monix_blog_wp_date_format',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Wordpress Default Date Format for Blog Page Post', 'monix') ,

				'sub_desc' => esc_html__('On/Off for default wordpress date format.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),			

			array(

				'id' => 'monix_blog_section_title',

				'type' => 'text',

				'title' => esc_html__('Blog Section Title', 'monix') ,

				'sub_desc' => esc_html__('Enter blog section title here. To bold the text, use <span class="bold">BLOG</span>', 'monix') ,

			),	
			array(

				'id' => 'monix_blog_section_description',

				'type' => 'textarea',

				'title' => esc_html__('Blog Section Description', 'monix') ,

				'sub_desc' => esc_html__('Enter blog section description here.', 'monix') ,

			),
			array(

				'id' => 'monix_blog_section_post_btn_label',

				'type' => 'text',

				'title' => esc_html__('Blog Section Post Button Label', 'monix') ,

				'sub_desc' => esc_html__('Enter blog section post button name. Example: Read more', 'monix') ,

			),				

			

	

			array(

				'id' => 'monix_blog_section_title_color',

				'type' => 'color',

				'title' => esc_html__('Blog Section Title Color', 'monix') ,

				'sub_desc' => esc_html__('Choose blog section title color here.', 'monix') ,

				'std' => '',

			),			

			array(

				'id' => 'monix_blog_section_description_color',

				'type' => 'color',

				'title' => esc_html__('Blog Section Description Color', 'monix') ,

				'sub_desc' => esc_html__('Choose blog section description color here.', 'monix') ,

				'std' => '',

			),			

			array(

				'id' => 'monix_blog_section_date_bg_color',

				'type' => 'color',

				'title' => esc_html__('Blog Section Post Date Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose blog section date background color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_blog_pagination_bg_color',

				'type' => 'color',

				'title' => esc_html__('Blog Page Pagination Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose blog page pagination background color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_categorised_blog_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Categorised Blog Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off categorised blog section for blog page.', 'monix') ,

				'switch' => true,

				'std' => '0'

			),	

			array(

				'id' => 'monix_categorised_blog_category',

				'type' => 'text',

				'title' => esc_html__('Which category post want to display?', 'monix') ,

				'sub_desc' => esc_html__('Enter here category ID only. Example:4', 'monix') ,

			),	

			array(

				'id' => 'monix_categorised_blog_section_post_no',

				'type' => 'text',

				'title' => esc_html__('How many post want to display?', 'monix') ,

				'sub_desc' => esc_html__('Enter here numeric number only.Example:4', 'monix') ,

			),		

			array(

				'id' => 'monix_categorised_blog_section_title',

				'type' => 'text',

				'title' => esc_html__('Categorised Blog Section Title', 'monix') ,

				'sub_desc' => esc_html__('Enter here categorised blog section headline.To bold the text, use <span class="bold">BLOG</span>', 'monix') ,

			),

			array(

				'id' => 'monix_categorised_blog_post_btn_label',

				'type' => 'text',

				'title' => esc_html__('Categorised Blog Post Button Label', 'monix') ,

				'sub_desc' => esc_html__('Enter categorised blog post button name. Example: Read more', 'monix') ,

			),				

			array(

				'id' => 'monix_categorised_blog_section_title_color',

				'type' => 'color',

				'title' => esc_html__('Categorised Blog Section Title Color', 'monix') ,

				'sub_desc' => esc_html__('Choose categorised blog headline color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_categorised_blog_section_navigation_color',

				'type' => 'color',

				'title' => esc_html__('Categorised Blog Section Navigation Button Color', 'monix') ,

				'sub_desc' => esc_html__('Choose categorised blog navigation button color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_categorised_blog_post_date_bg_color',

				'type' => 'color',

				'title' => esc_html__('Categorised Blog Section Post Date Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose categorised blog section post date background color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_blog_page_subscribe_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Blog page Newsletter Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off blog page newsletter section', 'monix') ,

				'switch' => true,

				'std' => '0'

			),	

			array(

				'id' => 'monix_blog_page_subscribe_title',

				'type' => 'text',

				'title' => esc_html__('Blog Newsletter Section Title', 'monix') ,

				'sub_desc' => esc_html__('Enter newsletter section title here. To bold the text, use <span class="bold">BLOG</span>', 'monix') ,

			),	



			array(

				'id' => 'monix_blog_page_subscribe_description',

				'type' => 'textarea',

				'title' => esc_html__('Blog Newsletter Section Description', 'monix') ,

				'sub_desc' => esc_html__('Enter newsletter section description here.', 'monix') ,

			),	

			array(

				'id' => 'monix_blog_page_subscribe_title_color',

				'type' => 'color',

				'title' => esc_html__('Blog Newsletter Section Title Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section title color here.', 'monix') ,

				'std' => '',

			),			

			array(

				'id' => 'monix_blog_page_subscribe_description_color',

				'type' => 'color',

				'title' => esc_html__('Blog Newsletter Section Description Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section description color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_blog_page_subscribe_bg_color',

				'type' => 'color',

				'title' => esc_html__('Blog Newsletter Section Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section background color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_blog_page_subscribe_btn_color',

				'type' => 'color',

				'title' => esc_html__('Blog Newsletter Section Button Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section button color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_blog_page_subscribe_input_field_color',

				'type' => 'color',

				'title' => esc_html__('Blog Newsletter Section Input Field Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section input field color here.', 'monix') ,

				'std' => '',

			),				

		)

	);



	// section for Single Post



	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'cog',

		'icon_class' => 'icon-large',

		'title' => esc_html__('Single Post Settings', 'monix') ,

		'desc' => wp_kses(__('<p class="description">Post Settings Page</p>', 'monix') , $allowed_html_array) ,

		'fields' => array(

			array(
				'id' => 'monix_single_post_style',
				'type' => 'radio',
				'title' => esc_html__('Turn On/Off Sidebar', 'monix') ,
				'options' => array(
					'1' => esc_html__('Sidebar with Single Post - Off', 'monix') ,
					'2' => esc_html__('Sidebar with Single Post - On', 'monix') ,
				) , // Must provide key => value pairs for radio options
				'std' => '2'
			),
			array(
				'id' => 'monix_single_style',
				'type' => 'radio',
				'title' => esc_html__('Choose Post Layout', 'monix') ,
				'options' => array(
					'1' => esc_html__('Post Layout One', 'monix') ,
					'2' => esc_html__('Post Layout Two', 'monix') ,
				) , // Must provide key => value pairs for radio options
				'std' => '1'
			) ,

			array(

				'id' => 'monix_single_post_heading_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Single Post Heading Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off page heading for single post Page.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),

			array(

				'id' => 'monix_single_post_heading_bg_image',

				'type' => 'upload',

				'title' => esc_html__('Upload Single Post Heading Section Background Image', 'monix') ,

				'sub_desc' => esc_html__('upload here image for heading section background.', 'monix') ,

			),

			array(

				'id' => 'monix_single_post_breadcrumb_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Single Post Breadcrumb Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off page breadcrumb for single post Page.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),			

			array(

				'id' => 'monix_single_post_breadcrumb_bg_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Breadcrumb Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose the background color for single post background section.', 'monix') ,

				'std' => '',

			) ,

			array(

				'id' => 'monix_single_post_comment_info',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Single Post Comments Meta', 'monix') ,

				'sub_desc' => esc_html__('On/Off Comments Meta for single post Page.', 'monix') ,

				'switch' => true,

				'std' => '0'

			),	
			
			array(

				'id' => 'monix_single_post_date_info',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Single Post Date Info', 'monix') ,

				'sub_desc' => esc_html__('On/Off page date info for single post Page.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),	

			array(

				'id' => 'monix_single_post_wp_date_format',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Wordpress Default Date Format for Single Post', 'monix') ,

				'sub_desc' => esc_html__('This option is only for Post Layout Two.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),			

			array(

				'id' => 'monix_single_post_date_bg_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Date Background Color', 'monix') ,

				'sub_desc' => esc_html__('This option is only for Post Layout Two.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_single_post_social_sharing',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Single Post Social Sharing', 'monix') ,

				'sub_desc' => esc_html__('On/Off  social sharing for single post Page.', 'monix') ,

				'switch' => true,

				'std' => '0'

			),

			array(

				'id' => 'monix_blog_single_meta_tags',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Single Post Meta Tags', 'monix') ,

				'sub_desc' => esc_html__('On/Off post single meta tags for single post Page.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),	
			
			array(

				'id' => 'monix_blog_single_tag_cats',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Single Tags and Categories', 'monix') ,

				'sub_desc' => esc_html__('On/Off Single Tags and Categories for single post Page.', 'monix') ,

				'switch' => true,

				'std' => '0'

			),	
			
			array(

				'id' => 'monix_single_post_prev_next',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Next and Previous Posts', 'monix') ,

				'sub_desc' => esc_html__('On/Off ext and Previous Posts below each post.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),

			array(

				'id' => 'monix_single_post_cat_blog_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Categorised Blog Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off categorised blog section for blog page.', 'monix') ,

				'switch' => true,

				'std' => '0'

			),	

			array(

				'id' => 'monix_categorised_blog_category_single_post',

				'type' => 'text',

				'title' => esc_html__('Which category post want to display?', 'monix') ,

				'sub_desc' => esc_html__('Enter here category ID only. Example:4', 'monix') ,

			),	

			array(

				'id' => 'monix_single_post_cat_blog_section_post_no',

				'type' => 'text',

				'title' => esc_html__('How many post want to display?', 'monix') ,

				'sub_desc' => esc_html__('Enter here numeric number only.Example:4', 'monix') ,

			),		

			array(

				'id' => 'monix_single_post_cat_blog_section_title',

				'type' => 'text',

				'title' => esc_html__('Categorised Blog Section Title', 'monix') ,

				'sub_desc' => esc_html__('Enter here categorised blog section headline.To bold the text, use <span class="bold">BLOG</span>', 'monix') ,

			),

			array(

				'id' => 'monix_single_post_cat_blog_post_btn_label',

				'type' => 'text',

				'title' => esc_html__('Categorised Blog Post Button Label', 'monix') ,

				'sub_desc' => esc_html__('Enter categorised blog post button name. Example: Read more', 'monix') ,

			),				

			array(

				'id' => 'monix_single_post_cat_blog_section_title_color',

				'type' => 'color',

				'title' => esc_html__('Categorised Blog Section Title Color', 'monix') ,

				'sub_desc' => esc_html__('Choose categorised blog headline color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_single_post_cat_blog_section_nav_color',

				'type' => 'color',

				'title' => esc_html__('Categorised Blog Section Navigation Button Color', 'monix') ,

				'sub_desc' => esc_html__('Choose categorised blog navigation button color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_single_post_cat_blog_post_date_bg_color',

				'type' => 'color',

				'title' => esc_html__('Categorised Blog Section Post Date Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose categorised blog section post date background color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_single_post_subscribe_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Blog page Newsletter Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off blog page newsletter section', 'monix') ,

				'switch' => true,

				'std' => '0'

			),	

			array(

				'id' => 'monix_single_post_subscribe_title',

				'type' => 'text',

				'title' => esc_html__('Single Post Newsletter Section Title', 'monix') ,

				'sub_desc' => esc_html__('Enter newsletter section title here. To bold the text, use <span class="bold">BLOG</span>', 'monix') ,

			),	



			array(

				'id' => 'monix_single_post_subscribe_description',

				'type' => 'textarea',

				'title' => esc_html__('Single Post Newsletter Section Description', 'monix') ,

				'sub_desc' => esc_html__('Enter newsletter section description here.', 'monix') ,

			),	

			array(

				'id' => 'monix_single_post_subscribe_title_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Newsletter Section Title Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section title color here.', 'monix') ,

				'std' => '',

			),			

			array(

				'id' => 'monix_single_post_subscribe_description_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Newsletter Section Description Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section description color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_single_post_subscribe_bg_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Newsletter Section Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section background color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_single_post_subscribe_btn_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Newsletter Section Button Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section button color here.', 'monix') ,

				'std' => '',

			),	

			array(

				'id' => 'monix_single_post_subscribe_input_field_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Newsletter Section Input Field Color', 'monix') ,

				'sub_desc' => esc_html__('Choose newsletter section input field color here.', 'monix') ,

				'std' => '',

			),	
			array(

				'id' => 'monix_single_post_blockquote_left_border_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Blockquote Left Border Color', 'monix') ,

				'sub_desc' => esc_html__('Choose blockquote left border color here.', 'monix') ,

				'std' => '',

			),	
			array(

				'id' => 'monix_single_post_blockquote_bg_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Blockquote Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose blockquote background color here.', 'monix') ,

				'std' => '',

			),		
			array(

				'id' => 'monix_single_post_comment_btn_bg_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Comment Button Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose post comment button background color here.', 'monix') ,

				'std' => '',

			),	
			array(

				'id' => 'monix_single_post_comment_btn_text_color',

				'type' => 'color',

				'title' => esc_html__('Single Post Comment Button Text Color', 'monix') ,

				'sub_desc' => esc_html__('Choose post comment button Text color here.', 'monix') ,

				'std' => '',

			),			

		)

	);

	

	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'cog',

		'icon_class' => 'icon-large',

		'title' => esc_html__('Single Page Settings', 'monix') ,

		'desc' => wp_kses(__('<p class="description">Single Page settings for Default Page Template</p>', 'monix') , $allowed_html_array) ,

		'fields' => array(

			array(

				'id' => 'monix_page_heading_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Page Heading Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off page heading for page.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),

			array(

				'id' => 'monix_page_heading_bg_image',

				'type' => 'upload',

				'title' => esc_html__('Upload Page Heading Section Background Image', 'monix') ,

				'sub_desc' => esc_html__('upload here image for heading section background.', 'monix') ,

			),

			array(

				'id' => 'monix_page_breadcrumb_section',

				'type' => 'checkbox',

				'title' => esc_html__('On/Off Page Breadcrumb Section', 'monix') ,

				'sub_desc' => esc_html__('On/Off page Breadcrumb for page.', 'monix') ,

				'switch' => true,

				'std' => '1'

			),

			array(

				'id' => 'monix_single_page_breadcrumb_bg_color',

				'type' => 'color',

				'title' => esc_html__('Single Page Breadcrumb Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose the background color for single page breadcrumb  section.', 'monix') ,

				'std' => '',

			) ,				

		)

	);

	// section for Other color settings

	$sections[] = array(

		'icon_type' => 'iconfont',

		'icon' => 'cog',

		'icon_class' => 'icon-large',

		'title' => esc_html__('Other Color Settings', 'monix') ,

		'desc' => wp_kses(__('<p class="description">Other color setting for 404 page</p>', 'monix') , $allowed_html_array) ,

		'fields' => array(

			array(

				'id' => 'monix_404_btn_bg_color',

				'type' => 'color',

				'title' => esc_html__('404 page Button Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose the background color for 404 page.', 'monix') ,

				'std' => '',

			) ,
			array(

				'id' => 'monix_404_btn_hover_bg_color',

				'type' => 'color',

				'title' => esc_html__('404 page Button Hover Background Color', 'monix') ,

				'sub_desc' => esc_html__('Choose the button hover background color for 404 page.', 'monix') ,

				'std' => '',

			) ,
		

		)

	);



                        



	$tabs = array();



		$theme_data = wp_get_theme();

		$item_uri = $theme_data->get('ThemeURI');

		$description = $theme_data->get('Description');

		$author = $theme_data->get('Author');

		$author_uri = $theme_data->get('AuthorURI');

		$version = $theme_data->get('Version');

		$tags = $theme_data->get('Tags');



	

	$item_info = '<div class="redux-opts-section-desc">';

	$item_info .= '<p class="redux-opts-item-data description item-uri">' . wp_kses( __('<strong>Theme URL:</strong> ', 'monix'), $allowed_html_array ) . '<a href="' . esc_url( $item_uri ) . '" target="_blank">' . $item_uri . '</a></p>';

	$item_info .= '<p class="redux-opts-item-data description item-author">' . wp_kses( __('<strong>Author:</strong> ', 'monix'), $allowed_html_array ) . ($author_uri ? '<a href="' . esc_url( $author_uri ) . '" target="_blank">' . $author . '</a>' : $author) . '</p>';

	$item_info .= '<p class="redux-opts-item-data description item-version">' . wp_kses( __('<strong>Version:</strong> ', 'monix'), $allowed_html_array ) . $version . '</p>';

	$item_info .= '<p class="redux-opts-item-data description item-description">' . $description . '</p>';

	$item_info .= '<p class="redux-opts-item-data description item-tags">' . wp_kses( __('<strong>Tags:</strong> ', 'monix'), $allowed_html_array ) . implode(', ', $tags) . '</p>';

	$item_info .= '</div>';



	global $Redux_Options;

	$Redux_Options = new Redux_Options($sections, $args, $tabs);

}

add_action('init', 'monix_setup_framework_options', 0);