<?php
/*
Plugin Name: Elfsight Click To Call CC
Description: Let your users reach you by phone in just one click.
Plugin URI: https://elfsight.com/click-to-call-widget/codecanyon/?utm_source=markets&utm_medium=codecanyon&utm_campaign=click-to-call&utm_content=plugin-site
Version: 1.1.0
Author: Elfsight
Author URI: https://elfsight.com/?utm_source=markets&utm_medium=codecanyon&utm_campaign=click-to-call&utm_content=plugins-list
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');

$elfsight_click_to_call_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_click_to_call_config = json_decode(file_get_contents($elfsight_click_to_call_config_path), true);

new ElfsightClickToCallPlugin(
    array(
        'name' => esc_html__('Click To Call'),
        'description' => esc_html__('Let your users reach you by phone in just one click.'),
        'slug' => 'elfsight-click-to-call',
        'version' => '1.1.0',
        'text_domain' => 'elfsight-click-to-call',
        'editor_settings' => $elfsight_click_to_call_config['settings'],
        'editor_preferences' => $elfsight_click_to_call_config['preferences'],
        'script_url' => plugins_url('assets/elfsight-click-to-call.js', __FILE__),

        'plugin_name' => esc_html__('Elfsight Click To Call'),
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),

        'menu_icon' => plugins_url('assets/img/menu-icon.svg', __FILE__),
        'update_url' => esc_url('https://a.elfsight.com/updates/v1/'),

        'preview_url' => plugins_url('preview/preview.html', __FILE__),
        'observer_url' => plugins_url('preview/click-to-call-observer.js', __FILE__),

        'product_url' => esc_url('https://1.envato.market/Bd959'),
        'support_url' => esc_url('https://elfsight.ticksy.com/submit/#100015721')
    )
);

?>
